/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block.storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.render.block.storage.StorageTypeRenderer;
import net.satisfy.vinery.client.util.ClientUtil;
import net.satisfy.vinery.core.block.WineBottleBlock;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class NineBottleRenderer
implements StorageTypeRenderer {
    @Override
    public void render(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> itemStacks) {
        matrices.translate(-0.13, 0.335, 0.125);
        matrices.scale(0.9f, 0.9f, 0.9f);
        for (int i = 0; i < itemStacks.size(); ++i) {
            float y;
            float x;
            int line;
            Item item;
            ItemStack stack = (ItemStack)itemStacks.get(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            matrices.pushPose();
            int n = i >= 6 ? 3 : (line = i >= 3 ? 2 : 1);
            if (line == 1) {
                x = -0.35f * (float)i;
                y = 0.0f;
            } else if (line == 2) {
                x = -0.35f * (float)(i - 3);
                y = -0.33f;
            } else {
                x = -0.35f * (float)(i - 6);
                y = -0.66f;
            }
            matrices.translate(x, y, 0.0f);
            matrices.mulPose(Axis.XN.rotationDegrees(90.0f));
            BlockState state = blockItem.getBlock().defaultBlockState();
            if (state.hasProperty((Property)WineBottleBlock.FAKE_MODEL)) {
                state = (BlockState)state.setValue((Property)WineBottleBlock.FAKE_MODEL, (Comparable)Boolean.valueOf(false));
            }
            ClientUtil.renderBlock(state, matrices, vertexConsumers, entity);
            matrices.popPose();
        }
    }
}

