/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.util.GrapeType;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class GrapeBush
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE;
    private static final VoxelShape SHAPE;
    public final GrapeType type;
    public static final MapCodec<GrapeBush> CODEC;

    public GrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
        super(settings);
        this.type = type;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)this.grapeType().getSeeds());
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 1) {
            int x = world.random.nextInt(2);
            GrapeBush.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getGrapeType().getItem(), x + (bl ? 1 : 0)));
            world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        double growthChance = PlatformHelper.getGrapeGrowthChance();
        if (age < 3 && random.nextDouble() < growthChance && this.canGrowPlace((LevelReader)world, pos, state)) {
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            world.setBlock(pos, newState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
        return world.getRawBrightness(blockPos, 0) > 9;
    }

    public boolean canSurvive(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return this.canGrowPlace(world, blockPos, blockState) && this.mayPlaceOn(world.getBlockState(blockPos.below()), (BlockGetter)world, blockPos);
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.isSolidRender(world, pos);
    }

    public GrapeType grapeType() {
        return this.type;
    }

    public ItemStack getGrapeType() {
        return new ItemStack((ItemLike)this.grapeType().getFruit());
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.getValue((Property)AGE) + 1);
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockBehaviour.Properties.CODEC.fieldOf("settings").forGetter(BlockBehaviour::properties), (App)GrapeType.CODEC.fieldOf("type").forGetter(GrapeBush::grapeType)).apply((Applicative)inst, GrapeBush::new));
        AGE = BlockStateProperties.AGE_3;
        SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static class TaigaGrapeBush
    extends GrapeBush {
        public TaigaGrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
            super(settings, type);
        }

        @Override
        public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
            BlockPos pos;
            if (world.getRawBrightness(blockPos, 0) <= 4) {
                return false;
            }
            int size = 4;
            Iterator var2 = BlockPos.betweenClosed((BlockPos)blockPos.offset(-size, -2, -size), (BlockPos)blockPos.offset(size, 1, size)).iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while (world.getBlockState(pos = (BlockPos)var2.next()).getBlock() != Blocks.PODZOL && world.getBlockState(pos).getBlock() != Blocks.COARSE_DIRT && world.getBlockState(pos).getBlock() != Blocks.GRASS_BLOCK);
            return true;
        }

        protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
            return false;
        }
    }

    public static class SavannaGrapeBush
    extends GrapeBush {
        public SavannaGrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
            super(settings, type);
        }

        @Override
        public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
            return world.getRawBrightness(blockPos, 0) >= 14;
        }
    }
}

