/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.block.entity.LatticeBlockEntity;
import net.satisfy.vinery.core.item.GrapeBushSeedItem;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatticeBlock
extends StemBlock
implements EntityBlock {
    public static final BooleanProperty SUPPORT = BooleanProperty.create((String)"support");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
    protected static final VoxelShape EAST = LatticeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = LatticeBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = LatticeBlock.box((double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH = LatticeBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FLOOR = LatticeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final SoundEvent BREAK_SOUND_EVENT = SoundEvents.SWEET_BERRY_BUSH_BREAK;
    private static final SoundEvent PLACE_SOUND_EVENT = SoundEvents.SWEET_BERRY_BUSH_PLACE;

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SUPPORT, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFacingFace;
        Level level = context.getLevel();
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos clickedPos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockPos clickedFacingPos = clickedPos.relative(clickedFace.getOpposite());
        BlockState clickedFacingState = level.getBlockState(clickedFacingPos);
        if (context.getPlayer() != null && !context.getPlayer().isCrouching() && clickedFacingState.getBlock() instanceof LatticeBlock && (clickedFacingFace = (Direction)clickedFacingState.getValue((Property)FACING)) != clickedFace && clickedFacingFace.getOpposite() != clickedFace) {
            facing = clickedFacingFace;
        }
        boolean bottom = clickedFace == Direction.DOWN || clickedFace == Direction.UP;
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom));
        if (!bottom) {
            state = this.getConnection(state, (LevelAccessor)level, clickedPos);
        }
        return state;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (Boolean.TRUE.equals(state.getValue((Property)BOTTOM))) {
            return FLOOR;
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LatticeBlockEntity lattice;
        BlockEntity be;
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int age = (Integer)state.getValue((Property)AGE);
        if (stack.getItem() instanceof AxeItem) {
            BlockState newState = (BlockState)state.setValue((Property)SUPPORT, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SUPPORT) == false));
            BlockState updateState = this.getConnection(newState, (LevelAccessor)world, pos);
            world.setBlock(pos, updateState, 3);
            return ItemInteractionResult.SUCCESS;
        }
        Item updateState = stack.getItem();
        if (updateState instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seedItem = (GrapeBushSeedItem)updateState;
            GrapeType type = seedItem.getType();
            if (age == 0 && type.isLattice()) {
                BlockState newState = this.withAge(state, 1, type);
                world.setBlock(pos, newState, 3);
                BlockEntity be2 = world.getBlockEntity(pos);
                if (be2 instanceof LatticeBlockEntity) {
                    LatticeBlockEntity lattice2 = (LatticeBlockEntity)be2;
                    lattice2.setAge(1);
                    lattice2.setGrapeType(type);
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                world.playSound(null, pos, PLACE_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (age > 0 && stack.getItem() == Items.SHEARS) {
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.getDirection());
            }
            this.dropGrapeSeeds(world, state, pos, hit.getDirection());
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
            be = world.getBlockEntity(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(0);
            }
            world.playSound(player, pos, BREAK_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (age > 2) {
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            this.dropGrapes(world, state, pos, hit.getDirection());
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            be = world.getBlockEntity(pos);
            if (be instanceof LatticeBlockEntity) {
                lattice = (LatticeBlockEntity)be;
                lattice.setAge(1);
            }
            world.playSound(player, pos, BREAK_SOUND_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Random rand = new Random();
        if (rand.nextInt(100) >= 98 || this.isMature(state)) {
            return;
        }
        int age = (Integer)state.getValue((Property)AGE);
        GrapeType type = (GrapeType)state.getValue((Property)GRAPE);
        BlockState newState = this.withAge(state, age + 1, type);
        world.setBlock(pos, newState, 2);
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof LatticeBlockEntity) {
            LatticeBlockEntity lattice = (LatticeBlockEntity)be;
            lattice.setAge(age + 1);
            lattice.setGrapeType(type);
        }
        super.randomTick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            if ((Integer)state.getValue((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos, null);
            }
            if ((Integer)state.getValue((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos, null);
            }
            world.destroyBlock(pos, true);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        return !this.isMature(state) && age > 0 && age < 4;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return this.getConnection(state, world, pos);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
        return !this.isMature(state) && (Integer)state.getValue((Property)AGE) > 0;
    }

    public BlockState getConnection(BlockState state, LevelAccessor level, BlockPos currentPos) {
        boolean sideR;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM);
        BlockState stateL = level.getBlockState(currentPos.relative(facing.getClockWise()));
        BlockState stateR = level.getBlockState(currentPos.relative(facing.getCounterClockWise()));
        boolean sideL = stateL.getBlock() instanceof LatticeBlock && stateL.getValue((Property)FACING) == facing && (Boolean)stateL.getValue((Property)BOTTOM) == bottom;
        boolean bl = sideR = stateR.getBlock() instanceof LatticeBlock && stateR.getValue((Property)FACING) == facing && (Boolean)stateR.getValue((Property)BOTTOM) == bottom;
        GeneralUtil.LineConnectingType type = sideL && sideR ? GeneralUtil.LineConnectingType.MIDDLE : (sideR ? GeneralUtil.LineConnectingType.LEFT : (sideL ? GeneralUtil.LineConnectingType.RIGHT : GeneralUtil.LineConnectingType.NONE));
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TYPE, SUPPORT, BOTTOM});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LatticeBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

