/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.StorageBlock;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.item.DrinkBlockItem;
import net.satisfy.vinery.core.registry.StorageTypeRegistry;
import net.satisfy.vinery.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class WineBottleBlock
extends StorageBlock {
    private static final VoxelShape SHAPE = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    public static final BooleanProperty FAKE_MODEL = BooleanProperty.create((String)"fake_model");
    private final int maxCount;

    public WineBottleBlock(BlockBehaviour.Properties settings, int maxCount) {
        super(settings);
        this.maxCount = maxCount;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FAKE_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            NonNullList<ItemStack> inventory = wineEntity.getInventory();
            if (this.canInsertStack(stack) && this.willFitStack(stack, inventory)) {
                int posInE = this.getFirstEmptySlot(inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (!world.isClientSide()) {
                    wineEntity.setStack(posInE, stack.split(1));
                    if (player.isCreative()) {
                        stack.grow(1);
                    }
                    world.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (stack.isEmpty() && !this.isEmpty(inventory)) {
                int posInE = this.getLastFullSlot(inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (!world.isClientSide()) {
                    ItemStack wine = wineEntity.removeStack(posInE);
                    if (!player.getInventory().add(wine)) {
                        player.drop(wine, false);
                    }
                    if (this.isEmpty(inventory)) {
                        world.destroyBlock(pos, false);
                    }
                    world.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isEmpty(NonNullList<ItemStack> inventory) {
        for (ItemStack stack : inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySlot(NonNullList<ItemStack> inventory) {
        for (ItemStack stack : inventory) {
            if (!stack.isEmpty()) continue;
            return inventory.indexOf((Object)stack);
        }
        return Integer.MIN_VALUE;
    }

    public int getLastFullSlot(NonNullList<ItemStack> inventory) {
        for (int i = inventory.size() - 1; i >= 0; --i) {
            if (((ItemStack)inventory.get(i)).isEmpty()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FAKE_MODEL});
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos)) {
            levelAccessor.destroyBlock(blockPos, true);
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    public int size() {
        return this.maxCount;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.WINE_BOTTLE;
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.is(TagRegistry.SMALL_BOTTLE);
    }

    public boolean willFitStack(ItemStack itemStack, NonNullList<ItemStack> inventory) {
        Pair<Integer, Integer> p = WineBottleBlock.getFilledAmountAndBiggest(inventory);
        int biggest = (Integer)p.getSecond();
        int count = (Integer)p.getFirst();
        int stackCount = WineBottleBlock.getCount(itemStack);
        if (biggest == Integer.MAX_VALUE) {
            return true;
        }
        return stackCount > count && count < biggest;
    }

    public static Pair<Integer, Integer> getFilledAmountAndBiggest(NonNullList<ItemStack> inventory) {
        int count = 0;
        int biggest = Integer.MAX_VALUE;
        for (ItemStack stack : inventory) {
            DrinkBlockItem item;
            if (stack.isEmpty()) continue;
            ++count;
            Item item2 = stack.getItem();
            if (!(item2 instanceof DrinkBlockItem) || !((item2 = (item = (DrinkBlockItem)item2).getBlock()) instanceof WineBottleBlock)) continue;
            WineBottleBlock wine = (WineBottleBlock)item2;
            if (wine.maxCount >= biggest) continue;
            biggest = wine.maxCount;
        }
        return new Pair((Object)count, (Object)biggest);
    }

    public static int getCount(ItemStack itemStack) {
        DrinkBlockItem item;
        Item item2 = itemStack.getItem();
        if (item2 instanceof DrinkBlockItem && (item2 = (item = (DrinkBlockItem)item2).getBlock()) instanceof WineBottleBlock) {
            WineBottleBlock wine = (WineBottleBlock)item2;
            return wine.maxCount;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getSection(Float aFloat, Float aFloat1) {
        return 0;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }
}

