/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.components.WineYearComponent;
import net.satisfy.vinery.core.registry.DataComponentRegistry;
import net.satisfy.vinery.core.util.WineYears;

public final class WineDebugCommands {
    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, selection) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wine").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"age").then(Commands.argument((String)"years", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(ctx -> WineDebugCommands.ageHeld((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"years")))))).then(Commands.literal((String)"info").executes(ctx -> WineDebugCommands.infoHeld((CommandSourceStack)ctx.getSource())))));
    }

    private static int ageHeld(CommandSourceStack source, int years) {
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            source.sendFailure((Component)Component.literal((String)"Player required"));
            return 0;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No item in main hand"));
            return 0;
        }
        ServerLevel level = player.serverLevel();
        int targetYear = WineYears.getYear((Level)level) - years;
        int amplifier = WineYears.getEffectLevel(stack, (Level)level);
        int duration = WineYears.getEffectDuration(stack, (Level)level);
        stack.set((DataComponentType)DataComponentRegistry.WINE_YEAR.get(), (Object)new WineYearComponent(targetYear, amplifier, duration));
        source.sendSuccess(() -> Component.literal((String)("Wine age set to " + years + " years")), false);
        return 1;
    }

    private static int infoHeld(CommandSourceStack source) {
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            source.sendFailure((Component)Component.literal((String)"Player required"));
            return 0;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No item in main hand"));
            return 0;
        }
        ServerLevel level = player.serverLevel();
        int age = WineYears.getWineAge(stack, (Level)level);
        int days = WineYears.getWineAgeDays(stack, (Level)level);
        int amplifier = WineYears.getEffectLevel(stack, (Level)level);
        int duration = WineYears.getEffectDuration(stack, (Level)level);
        source.sendSuccess(() -> Component.literal((String)("Age: " + age + "y, " + days + "d | Amp: " + amplifier + " | Dur: " + duration + " ticks")), false);
        return 1;
    }
}

