/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.rei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.satisfy.vinery.core.compat.rei.press.ApplePressCategory;
import net.satisfy.vinery.core.compat.rei.press.ApplePressDisplay;
import net.satisfy.vinery.core.compat.rei.press.ApplePressFermentingCategory;
import net.satisfy.vinery.core.compat.rei.press.ApplePressFermentingDisplay;
import net.satisfy.vinery.core.compat.rei.wine.FermentationBarrelCategory;
import net.satisfy.vinery.core.compat.rei.wine.FermentationBarrelDisplay;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;

public class VineryReiClientPlugin {
    public static void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new FermentationBarrelCategory());
        registry.add((DisplayCategory)new ApplePressCategory());
        registry.add((DisplayCategory)new ApplePressFermentingCategory());
        registry.addWorkstations(FermentationBarrelDisplay.FERMENTATION_BARREL_DISPLAY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.FERMENTATION_BARREL.get()))});
        registry.addWorkstations(ApplePressDisplay.APPLE_PRESS_DISPLAY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.APPLE_PRESS.get()))});
        registry.addWorkstations(ApplePressFermentingDisplay.APPLE_PRESS_DISPLAY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.APPLE_PRESS.get()))});
    }

    public static void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(FermentationBarrelRecipe.class, FermentationBarrelRecipe.Type, FermentationBarrelDisplay::new);
        registry.registerRecipeFiller(ApplePressMashingRecipe.class, ApplePressMashingRecipe.Type, ApplePressDisplay::new);
        registry.registerRecipeFiller(ApplePressFermentingRecipe.class, ApplePressFermentingRecipe.Type, ApplePressFermentingDisplay::new);
    }

    public static List<Ingredient> ingredients(Recipe<RecipeInput> recipe, ItemStack stack) {
        ArrayList<Ingredient> l = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getIngredients());
        l.add(0, Ingredient.of((ItemLike[])new ItemLike[]{stack.getItem()}));
        return l;
    }
}

