/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.compat.rei.wine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.ObjectRegistry;

public class FermentationBarrelDisplay
extends BasicDisplay {
    public static final CategoryIdentifier<FermentationBarrelDisplay> FERMENTATION_BARREL_DISPLAY = CategoryIdentifier.of((String)"vinery", (String)"fermentation_barrel_display");
    private final int juiceAmount;
    private final String juiceType;

    public FermentationBarrelDisplay(RecipeHolder<FermentationBarrelRecipe> recipe) {
        this(FermentationBarrelDisplay.prepareInputs((FermentationBarrelRecipe)recipe.value()), FermentationBarrelDisplay.prepareOutputs((FermentationBarrelRecipe)recipe.value()), ((FermentationBarrelRecipe)recipe.value()).getJuiceData().amount(), ((FermentationBarrelRecipe)recipe.value()).getJuiceData().type());
    }

    public FermentationBarrelDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, int juiceAmount, String juiceType) {
        super(inputs, outputs);
        this.juiceAmount = juiceAmount;
        this.juiceType = juiceType;
    }

    public int getJuiceAmount() {
        return this.juiceAmount;
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    private static List<EntryIngredient> prepareInputs(FermentationBarrelRecipe recipe) {
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>(EntryIngredients.ofIngredients(recipe.getIngredients()));
        ingredients.add(EntryIngredients.of((ItemStack)new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get())));
        return ingredients;
    }

    private static List<EntryIngredient> prepareOutputs(FermentationBarrelRecipe recipe) {
        return Collections.singletonList(EntryIngredients.of((ItemStack)recipe.getResultItem(null)));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return FERMENTATION_BARREL_DISPLAY;
    }
}

