/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.effect;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MagnetEffect
extends MobEffect {
    public MagnetEffect() {
        super(MobEffectCategory.BENEFICIAL, 12058736);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).isShiftKeyDown()) {
            List entities = player.getCommandSenderWorld().getEntities((Entity)player, player.getBoundingBox().inflate((double)(5 + amplifier)), p -> p instanceof ItemEntity);
            for (Entity entityNearby : entities) {
                if (player.getInventory().getFreeSlot() == -1) {
                    Vec3 vec3 = entity.getEyePosition().subtract(entityNearby.position());
                    int amp = amplifier + 1;
                    entityNearby.setPosRaw(entityNearby.getX(), entityNearby.getY() + vec3.y * 0.015 * (double)Math.min(amp, 3), entityNearby.getZ());
                    if (entity.level().isClientSide) {
                        entityNearby.yOld = entityNearby.getY();
                    }
                    entityNearby.setDeltaMovement(entityNearby.getDeltaMovement().scale(0.95).add(vec3.normalize().yRot(0.2f).scale(0.1 * (double)amp)));
                    continue;
                }
                entityNearby.playerTouch(player);
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int i, int j) {
        return true;
    }
}

