/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.neoforge.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.satisfy.vinery.core.util.VillagerUtil;
import net.satisfy.vinery.neoforge.core.config.VineryForgeConfig;
import net.satisfy.vinery.neoforge.core.registry.VineryNeoForgeVillagers;

@EventBusSubscriber(modid="vinery")
public class VineryForgeEventhandler {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType().equals((Object)VineryNeoForgeVillagers.WINEMAKER.get())) {
            HashMap<Integer, List<VillagerTrades.ItemListing>> trades = new HashMap<Integer, List<VillagerTrades.ItemListing>>();
            VineryForgeEventhandler.loadTradesFromConfig(trades, VineryForgeConfig.level1TradesCache, 1);
            VineryForgeEventhandler.loadTradesFromConfig(trades, VineryForgeConfig.level2TradesCache, 2);
            VineryForgeEventhandler.loadTradesFromConfig(trades, VineryForgeConfig.level3TradesCache, 3);
            VineryForgeEventhandler.loadTradesFromConfig(trades, VineryForgeConfig.level4TradesCache, 4);
            VineryForgeEventhandler.loadTradesFromConfig(trades, VineryForgeConfig.level5TradesCache, 5);
            event.getTrades().clear();
            event.getTrades().putAll(trades);
        }
    }

    private static void loadTradesFromConfig(Map<Integer, List<VillagerTrades.ItemListing>> trades, List<? extends String> configList, int level) {
        ArrayList<VillagerUtil.SellItemFactory> tradeList = new ArrayList<VillagerUtil.SellItemFactory>();
        for (String string : configList) {
            String[] parts = string.split("\\|");
            if (parts.length != 5) continue;
            String itemName = parts[0];
            int price = Integer.parseInt(parts[1]);
            int quantity = Integer.parseInt(parts[2]);
            int maxUses = Integer.parseInt(parts[3]);
            boolean isSelling = Boolean.parseBoolean(parts[4]);
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName));
            if (item == null) continue;
            Object listing = isSelling ? new VillagerUtil.SellItemFactory(item, price, quantity, maxUses) : new VillagerUtil.BuyForOneEmeraldFactory((ItemLike)item, price, quantity, maxUses);
            tradeList.add((VillagerUtil.SellItemFactory)listing);
        }
        trades.put(level, tradeList);
    }
}

